/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.VWImageIcon;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;

public final class VWStepUtils {
    public static final int UNKNOWN_STEP = -1;
    public static final int LAUNCH_STEP = 0;
    public static final int USER_STEP = 1;
    public static final int START_USER_STEP = 2;
    public static final int QUEUE_STEP = 3;
    public static final int START_QUEUE_STEP = 4;
    public static final int DUMMY_STEP = 5;
    public static final int START_DUMMY_STEP = 6;
    public static final int GENERAL_STEP = 7;
    public static final int START_GENERAL_STEP = 8;
    public static final int SUBMAP_STEP = 9;
    public static final int START_SUBMAP_STEP = 10;
    public static final int SYSTEM_STEP = 11;
    public static final int START_SYSTEM_STEP = 12;
    public static final int COMPONENT_STEP = 13;
    public static final int START_COMPONENT_STEP = 14;

    public static String getStepPropertiesPanelClassName(VWMapNode mapNode) {
        String iconName = null;
        try {
            Object obj;
            VWAttributeInfo attribute = mapNode.getAttributeInfo();
            if (attribute != null && (obj = attribute.getFieldValue("UI_StepPropertiesPanelClass")) != null && obj instanceof String) {
                iconName = (String)obj;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return iconName;
    }

    public static String getIconName(VWMapNode mapNode) {
        String iconName = null;
        try {
            Object obj;
            VWAttributeInfo attribute = mapNode.getAttributeInfo();
            if (attribute != null && (obj = attribute.getFieldValue("UI_IconName")) != null && obj instanceof String) {
                iconName = (String)obj;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return iconName;
    }

    public static String getStepDisplayName(VWMapNode mapNode) {
        try {
            String name = mapNode.getName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return VWResource.s_blankStepLabel.toString(Integer.toString(mapNode.getStepId() + 1));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return VWResource.s_blankName;
        }
    }

    public static int getStepType(VWMapNode mapNode) {
        int nStepType = -1;
        boolean bIsOldStyleStepType = false;
        try {
            if (mapNode != null) {
                VWAttributeInfo attributeInfo = mapNode.getAttributeInfo();
                if (attributeInfo != null) {
                    Object obj = attributeInfo.getFieldValue("UI_StepType");
                    if (obj != null && obj instanceof Integer) {
                        nStepType = VWStepUtils.convertNewStepTypeToOldStepType(mapNode, (Integer)obj);
                    } else {
                        bIsOldStyleStepType = true;
                    }
                } else {
                    attributeInfo = new VWAttributeInfo();
                    mapNode.setAttributeInfo(attributeInfo);
                    bIsOldStyleStepType = true;
                }
                if (bIsOldStyleStepType) {
                    nStepType = VWStepUtils.getStepTypeOldStyle(mapNode);
                    Integer newStepType = VWStepUtils.convertOldStepTypeToNewStepType(nStepType);
                    attributeInfo.deleteField("UI_StepType");
                    attributeInfo.setFieldValue("UI_StepType", newStepType);
                    mapNode.setAttributeInfo(attributeInfo);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nStepType;
    }

    public static void setStepType(VWMapNode mapNode, Integer stepType) {
        try {
            if (mapNode != null && stepType != null) {
                VWAttributeInfo attributeInfo;
                int nStepTypeValue = stepType;
                if (mapNode.getNodeType() == 2) {
                    switch (nStepTypeValue) {
                        case 2: {
                            nStepTypeValue = 3;
                            break;
                        }
                        case 4: {
                            nStepTypeValue = 5;
                            break;
                        }
                        case 6: {
                            nStepTypeValue = 7;
                            break;
                        }
                        case 8: {
                            nStepTypeValue = 9;
                        }
                    }
                }
                if ((attributeInfo = mapNode.getAttributeInfo()) == null) {
                    attributeInfo = new VWAttributeInfo();
                }
                attributeInfo.setFieldValue("UI_StepType", new Integer(nStepTypeValue));
                mapNode.setAttributeInfo(attributeInfo);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public static int getAttributeStepType(VWMapNode mapNode, boolean bUpdateMapNode) {
        int nNewStepType = -1;
        if (mapNode == null) {
            return nNewStepType;
        }
        try {
            VWAttributeInfo attributeInfo = mapNode.getAttributeInfo();
            if (attributeInfo == null) {
                return nNewStepType;
            }
            Object obj = attributeInfo.getFieldValue("UI_StepType");
            if (obj == null || !(obj instanceof Integer)) {
                return nNewStepType;
            }
            nNewStepType = (Integer)obj;
            switch (nNewStepType) {
                case 3: {
                    nNewStepType = 2;
                    break;
                }
                case 5: {
                    nNewStepType = 4;
                    break;
                }
                case 7: {
                    nNewStepType = 6;
                    break;
                }
                case 9: {
                    nNewStepType = 8;
                }
            }
            if (nNewStepType != -1 && bUpdateMapNode) {
                attributeInfo.deleteField("UI_StepType");
                attributeInfo.setFieldValue("UI_StepType", new Integer(nNewStepType));
                mapNode.setAttributeInfo(attributeInfo);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nNewStepType;
    }

    public static Icon getStepIcon(VWMapNode mapNode, VWSessionInfo sessionInfo) {
        try {
            String iconName;
            if (sessionInfo != null && (iconName = VWStepUtils.getIconName(mapNode)) != null) {
                VWImageIcon imageIcon;
                URL imageURL;
                iconName = iconName + "_16.gif";
                ClassLoader externalClassLoader = sessionInfo.getExternalClassLoader();
                if (externalClassLoader != null && (imageURL = externalClassLoader.getResource(iconName)) != null && (imageIcon = new VWImageIcon(imageURL)) != null) {
                    return imageIcon;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        switch (VWStepUtils.getStepType(mapNode)) {
            case 0: {
                return VWImageLoader.createImageIcon("launchstep_16.gif");
            }
            case 5: 
            case 6: {
                return VWImageLoader.createImageIcon("dummystep_16.gif");
            }
            case 1: 
            case 2: {
                return VWImageLoader.createImageIcon("userstep_16.gif");
            }
            case 3: 
            case 4: {
                return VWImageLoader.createImageIcon("queuestep_16.gif");
            }
            case 9: 
            case 10: {
                return VWImageLoader.createImageIcon("callstep_16.gif");
            }
            case 11: 
            case 12: {
                return VWImageLoader.createImageIcon("systemstep_16.gif");
            }
            case 13: 
            case 14: {
                return VWImageLoader.createImageIcon("componentstep_16.gif");
            }
        }
        return VWImageLoader.createImageIcon("blank.gif");
    }

    public static boolean isComponentStep(int stepType) {
        return stepType == 14 || stepType == 13;
    }

    public static boolean isGeneralStep(int stepType) {
        return stepType == 5 || stepType == 1 || stepType == 3;
    }

    public static boolean isStartGeneralStep(int stepType) {
        return stepType == 6 || stepType == 2 || stepType == 4;
    }

    public static boolean isStartStep(int stepType) {
        return stepType == 6 || stepType == 2 || stepType == 4 || stepType == 10 || stepType == 12 || stepType == 14;
    }

    public static boolean isSubmapStep(int stepType) {
        return stepType == 10 || stepType == 9;
    }

    public static boolean isSystemStep(int stepType) {
        return stepType == 12 || stepType == 11;
    }

    public static boolean isSameStep(int stepType, int type1, int type2) {
        if ((stepType & 0) != 0 && type1 == 0 && type2 == 0) {
            return true;
        }
        if ((stepType & 7) != 0 && VWStepUtils.isGeneralStep(type1) && VWStepUtils.isGeneralStep(type2)) {
            return true;
        }
        if ((stepType & 8) != 0 && VWStepUtils.isStartGeneralStep(type1) && VWStepUtils.isStartGeneralStep(type2)) {
            return true;
        }
        if ((stepType & 9) != 0 && VWStepUtils.isSubmapStep(type1) && VWStepUtils.isSubmapStep(type2)) {
            return true;
        }
        if ((stepType & 0xB) != 0 && VWStepUtils.isSystemStep(type1) && VWStepUtils.isSystemStep(type2)) {
            return true;
        }
        return (stepType & 0xD) != 0 && VWStepUtils.isComponentStep(type1) && VWStepUtils.isComponentStep(type2);
    }

    public static String getCalledMapName(VWMapNode mapNode) {
        String mapName;
        block5: {
            mapName = null;
            if (mapNode != null && mapNode instanceof VWCompoundStepDefinition) {
                try {
                    VWInstructionDefinition[] instructions = ((VWCompoundStepDefinition)mapNode).getInstructions();
                    if (instructions == null || instructions.length <= 0) break block5;
                    for (int i = 0; i < instructions.length; ++i) {
                        if (instructions[i].getAction() != 5) continue;
                        mapName = VWInstruction.CallInstructionGetSubmap(instructions[i]);
                        if (VWStringUtils.compare(mapName, "") == 0) {
                            mapName = null;
                        }
                        break;
                    }
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
        }
        return mapName;
    }

    public static String[] getCalledMapNames(VWMapNode mapNode) {
        Vector<String> calledMapNames = new Vector<String>();
        Object[] mapNames = null;
        try {
            VWInstructionDefinition[] instructionDefs;
            VWCompoundStepDefinition stepDef = (VWCompoundStepDefinition)mapNode;
            if (stepDef != null && (instructionDefs = stepDef.getInstructions()) != null) {
                for (int i = 0; i < instructionDefs.length; ++i) {
                    String calledMapName;
                    if (instructionDefs[i].getAction() != 5 || (calledMapName = VWInstruction.CallInstructionGetSubmap(instructionDefs[i])) == null || calledMapName.length() <= 0) continue;
                    boolean bFound = false;
                    for (int j = 0; j < calledMapNames.size(); ++j) {
                        String name = (String)calledMapNames.elementAt(j);
                        if (name.length() <= 0 || VWStringUtils.compare(name, calledMapName) != 0) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    calledMapNames.addElement(calledMapName);
                }
            }
            if (calledMapNames.size() > 0) {
                mapNames = new String[calledMapNames.size()];
                calledMapNames.copyInto(mapNames);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mapNames;
    }

    public static boolean isMapReferenced(String mapName, VWMapNode mapNode) {
        try {
            VWInstructionDefinition[] instructionDefs;
            VWCompoundStepDefinition stepDef = (VWCompoundStepDefinition)mapNode;
            if (stepDef != null && (instructionDefs = stepDef.getInstructions()) != null) {
                for (int i = 0; i < instructionDefs.length; ++i) {
                    String calledMapName = null;
                    switch (instructionDefs[i].getAction()) {
                        case 5: {
                            calledMapName = VWInstruction.CallInstructionGetSubmap(instructionDefs[i]);
                            break;
                        }
                        case 39: {
                            VWFaultDefinition fault = ((VWInvokeInstruction)instructionDefs[i]).getCatchAllFault();
                            if (fault == null || fault.getFaultMapName() == null) break;
                            calledMapName = fault.getFaultMapName();
                            break;
                        }
                    }
                    if (calledMapName == null || calledMapName.length() <= 0 || mapName.length() <= 0 || VWStringUtils.compare(mapName, calledMapName) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    private static int convertNewStepTypeToOldStepType(VWMapNode mapNode, Integer newStepType) {
        int nOldStepType = -1;
        try {
            if (newStepType != null) {
                switch (newStepType) {
                    case 1: {
                        nOldStepType = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        nOldStepType = VWStepUtils.getGeneralStepType((VWStepDefinition)mapNode);
                        break;
                    }
                    case 4: {
                        nOldStepType = 9;
                        break;
                    }
                    case 5: {
                        nOldStepType = 10;
                        break;
                    }
                    case 6: {
                        nOldStepType = 11;
                        break;
                    }
                    case 7: {
                        nOldStepType = 12;
                        break;
                    }
                    case 8: {
                        nOldStepType = 13;
                        break;
                    }
                    case 9: {
                        nOldStepType = 14;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nOldStepType;
    }

    private static Integer convertOldStepTypeToNewStepType(int nOldStepType) {
        Integer nNewStepType = null;
        switch (nOldStepType) {
            case 0: {
                nNewStepType = new Integer(1);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                nNewStepType = new Integer(2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                nNewStepType = new Integer(3);
                break;
            }
            case 9: {
                nNewStepType = new Integer(4);
                break;
            }
            case 10: {
                nNewStepType = new Integer(5);
                break;
            }
            case 11: {
                nNewStepType = new Integer(6);
                break;
            }
            case 12: {
                nNewStepType = new Integer(7);
                break;
            }
            case 13: {
                nNewStepType = new Integer(8);
                break;
            }
            case 14: {
                nNewStepType = new Integer(9);
                break;
            }
            default: {
                nNewStepType = new Integer(-1);
            }
        }
        return nNewStepType;
    }

    private static int getStepTypeOldStyle(VWMapNode mapNode) {
        int nStepType = -1;
        try {
            if (mapNode != null) {
                switch (mapNode.getNodeType()) {
                    case 1: {
                        nStepType = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        nStepType = mapNode instanceof VWStepDefinition ? VWStepUtils.getGeneralStepType((VWStepDefinition)mapNode) : VWStepUtils.getCompoundStepType((VWCompoundStepDefinition)mapNode);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nStepType;
    }

    private static int getGeneralStepType(VWStepDefinition stepDef) {
        boolean bIsStartType;
        int nStepType = -1;
        boolean bl = bIsStartType = stepDef.getNodeType() == 2;
        nStepType = stepDef.getParticipants() == null && stepDef.getQueueName() == null ? (bIsStartType ? 6 : 5) : (stepDef.getParticipants() == null && stepDef.getQueueName() != null && !stepDef.getQueueName().equals("Inbox") ? (bIsStartType ? 4 : 3) : (bIsStartType ? 2 : 1));
        return nStepType;
    }

    private static int getCompoundStepType(VWCompoundStepDefinition compoundStepDef) {
        int nStepType = -1;
        boolean bIsStartType = compoundStepDef.getNodeType() == 2;
        try {
            VWInstructionDefinition[] instructionDefs = compoundStepDef.getInstructions();
            nStepType = instructionDefs == null ? (bIsStartType ? 12 : 11) : (instructionDefs.length == 2 && instructionDefs[0].getAction() == 24 && instructionDefs[1].getAction() == 5 ? (bIsStartType ? 10 : 9) : (instructionDefs.length >= 2 && instructionDefs[0].getAction() == 24 && instructionDefs[1].getAction() == 24 ? (bIsStartType ? 14 : 13) : (bIsStartType ? 12 : 11)));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nStepType;
    }
}

